/*===========================================================================*\
 | SBKX.H (revision 1.0)                                                     |
 |      Manifest constants and prototypes of C Helper functions .            |
 |                                                                           |
 |---------------------------------------------------------------------------|
 | Copyright (c) Creative Technology Ltd, 1992-1993.                         |
 | All Rights Reserved.                                                      |
\*===========================================================================*/

#ifndef _SBKX_H
    #define _SBKX_H

#include "ctstddef.h"


#ifdef __cplusplus
extern "C" {
#endif


#define     UNUSED  0

/*
 *  Only large memory model is provided.  ALl functions are invoked
 *  through far call.
 */

/*  functions in file XMSRTN.ASM  */

WORD  FAR CDECL sbkGetXMSEntry (void);
WORD  FAR CDECL sbkAllocXM (WORD wKiloSize);
WORD  FAR CDECL sbkFreeXM (WORD wXMHandle);
WORD  FAR CDECL sbkMoveCMtoXM (BYTE FAR * lpSrcBuf, DWORD dwMoveLength,
                              WORD wXMHandle, DWORD dwXMOffset);
WORD  FAR CDECL sbkMoveXMtoCM (BYTE FAR * lpDestBuf, DWORD dwMoveLength,
                              WORD wXMHandle, DWORD dwXMOffset);

/*  function in DOSRW.C  */

WORD FAR CDECL sbkDosRead (int iFileHandle,
                           char FAR *lpBuffer,
                           WORD wLength,
                           WORD FAR * wByteRead);
WORD FAR CDECL sbkDosWrite (int iFileHandle,
                            char FAR *lpBuffer,
                            WORD wLength,
                            WORD FAR * wByteWritten);

int FAR CDECL sbkDosOpen (char FAR * lpFilename);

int FAR CDECL sbkDosCreate (char FAR * lpFilename);

void FAR CDECL sbkDosClose (int iFileHandle);

#ifdef __cplusplus
}
#endif

#endif      /* #ifndef _SBKX_H */
