'*==========================================================================*'
'*  SBKX.BI (revision 1.0)                                                  *'
'*       Manifest constants and prototypes of BASIC Helper functions .      *'
'*                                                                          *'
'*--------------------------------------------------------------------------*'
'*  Copyright (c) Creative Technology Ltd, 1992-1993.                       *'
'*  All Rights Reserved.                                                    *'
'*==========================================================================*'

TYPE SEARCHxREC
    reserved AS STRING * 21
    bAttrib  AS STRING * 1
    wTime    AS INTEGER
    wDate    AS INTEGER
    dwSize   AS LONG
    szName   AS STRING * 13
END TYPE

CONST UNUSED       = 0

CONST SEEKSET      = 0
CONST SEEKCUR      = 1
CONST SEEKEND      = 2

CONST READONLY     = &H01
CONST HIDDEN       = &H02
CONST SYSFILE      = &H04
CONST VOLUMEID     = &H08
CONST DIRECTORY    = &H10
CONST ARCHIVE      = &H20
CONST ANYFILE      = &H3F


' These functions are in ADDXADJ.ASM file
DECLARE   FUNCTION  sbkNormalizeSegment% (BYVAL wSegment%, BYVAL wOffset%)
DECLARE   FUNCTION  sbkNormalizeOffset%  (BYVAL wOffset%)


' These functions are in CVTTYPE.ASM file
DECLARE FUNCTION  sbkMakeDWord&   (BYVAL wHiWord%, BYVAL wLoWord%)
DECLARE FUNCTION  sbkMakeWord%    (BYVAL bHiByte%, BYVAL bLoByte%)
DECLARE FUNCTION  sbkHighWord%    (BYVAL dwData&)
DECLARE FUNCTION  sbkLowWord%     (BYVAL dwData&)
DECLARE FUNCTION  sbkHighByte%    (BYVAL wData%)
DECLARE FUNCTION  sbkLowByte%     (BYVAL wData%)


' These functions are in BSTRING.ASM file
DECLARE FUNCTION  sbkMakeBasicString$ (BYVAL lpCString&)
DECLARE SUB       sbkReleaseBasicString ()


' These functions are in XMSRTN.ASM file
DECLARE FUNCTION  sbkGetXMSEntry% CDECL ()
DECLARE FUNCTION  sbkAllocXM% CDECL (BYVAL wKiloSize%)
DECLARE FUNCTION  sbkFreeXM% CDECL (BYVAL wXMHandle%)
DECLARE FUNCTION  sbkMoveCMtoXM% CDECL (BYVAL lpSrcBuf&, BYVAL dwMoveLength&,_
                                        BYVAL wXMHandle%, BYVAL dwXMOffset&)
DECLARE FUNCTION  sbkMoveXMtoCM% CDECL (BYVAL lpDestBuf&, BYVAL dwMoveLength&,_
                                        BYVAL wXMHandle%, BYVAL dwXMOffset&)

' These functions are in FILEIO.ASM file
DECLARE FUNCTION  sbkDosOpen% CDECL (BYVAL lpFilename&)
DECLARE FUNCTION  sbkDosCreate% CDECL (BYVAL lpFilename&)
DECLARE SUB       sbkDosClose CDECL (BYVAL iFileHandle%)
DECLARE FUNCTION  sbkDosLSeek& CDECL (BYVAL iFileHandle%, BYVAL lOffset&, BYVAL wSeekMode%)
DECLARE FUNCTION  sbkFileSize& CDECL (BYVAL iFileHandle%)
DECLARE FUNCTION  sbkFindFile% CDECL (BYVAL lpFilename&)
DECLARE FUNCTION  sbkFindFirst% CDECL (BYVAL lpFilename&, BYVAL wAttributes%, SEG lpSearchRec AS SEARCHxREC)
DECLARE FUNCTION  sbkFindNext% CDECL (SEG lpSearchRec AS SEARCHxREC)

' These functions are in MEMORY.ASM file
DECLARE FUNCTION  sbkAllocMem% CDECL (BYVAL wParaSize%)
DECLARE SUB       sbkFreeMem CDECL (BYVAL wSegment%)


' These functions are in SBKX.BAS file
DECLARE FUNCTION  sbkMakeAsciizString& (BString$)
DECLARE FUNCTION  sbkLoadDriver% (DrvName$,wEmbedBuffer%)
DECLARE FUNCTION  sbkDosRead% (iFileHandle%, wSegment%, wOffset%, dwLength&)
DECLARE FUNCTION  sbkDosWrite% (iFileHandle%, wSegment%, wOffset%, dwLength&)
DECLARE SUB       sbkGetCmdLine (NumArgs%, Args$(), MaxArgs%)
' End Of File
