'*==========================================================================*'
'*  SBKWAVE.BI (revision 1.0)                                               *'
'*       API for CTWMEM.DRV and CTWSDK.DRV                                  *'
'*                                                                          *'
'*--------------------------------------------------------------------------*'
'*              Copyright (c) Creative Technology Ltd, 1992-1993.           *'
'*                            All Rights Reserved.                          *'
'*==========================================================================*'


'
' The following are API for CTWMEM driver.
'

DECLARE FUNCTION  ctwmContinue% CDECL (BYVAL wIOHandle%)
DECLARE FUNCTION  ctwmGetDrvError% CDECL ()
DECLARE FUNCTION  ctwmGetEnvSettings% CDECL (BYVAL lpszBlaster&)
DECLARE FUNCTION  ctwmGetIOParam% CDECL (BYVAL wIOHandle%, BYVAL wParamType%, SEG lpdwParam&)
DECLARE FUNCTION  ctwmGetParam% CDECL (BYVAL wParamType%, SEG lpdwParam&)
DECLARE FUNCTION  ctwmInit% CDECL ()
DECLARE FUNCTION  ctwmInputCM% CDECL (BYVAL wIOHandle%, BYVAL lpBuf&, BYVAL dwBufLen&)
DECLARE FUNCTION  ctwmInputXM% CDECL (BYVAL wIOHandle%, BYVAL wXMBHandle%, BYVAL dwXMBOffset&, BYVAL wkBXMBSize%)
DECLARE FUNCTION  ctwmOutputCM% CDECL (BYVAL wIOHandle%, BYVAL lpBuf&)
DECLARE FUNCTION  ctwmOutputXM% CDECL (BYVAL wIOHandle%, BYVAL wXMBHandle%, BYVAL dwXMBOffset&)
DECLARE FUNCTION  ctwmPause% CDECL (BYVAL wIOHandle%)
DECLARE FUNCTION  ctwmSetDMABuffer% CDECL (BYVAL wIOHandle%, BYVAL dw32BitAddx&, BYVAL w2kBHalfBufferSize%)
DECLARE FUNCTION  ctwmSetIOParam% CDECL (BYVAL wIOHandle%, BYVAL wParamType%, BYVAL dwParam&)
DECLARE SUB       ctwmSetSpeaker CDECL (BYVAL wfOnOff%)
DECLARE FUNCTION  ctwmStop% CDECL (BYVAL wIOHandle%)
DECLARE SUB       ctwmTerminate CDECL ()


' This function is used to set the entry point of the loaded CTWMEM driver.
' It has to be called before any other CTWMEM drivers' functions.

DECLARE SUB       ctwmSetDriverEntry (BYVAL wDrvSeg%)




'
' The following are API for CTWDSK driver.
'

DECLARE FUNCTION  ctwdContinue% CDECL (BYVAL wIOHandle%)
DECLARE FUNCTION  ctwdGetDrvError% CDECL ()
DECLARE FUNCTION  ctwdGetEnvSettings% CDECL (BYVAL lpszBlaster&)
DECLARE FUNCTION  ctwdGetExtError% CDECL ()
DECLARE FUNCTION  ctwdGetIOParam% CDECL (BYVAL wIOHandle%, BYVAL wParamType%, SEG lpdwParam&)
DECLARE FUNCTION  ctwdGetParam% CDECL (BYVAL wParamType%, SEG lpdwParam&)
DECLARE FUNCTION  ctwdInit% CDECL ()
DECLARE FUNCTION  ctwdInput% CDECL (BYVAL wIOHandle%, BYVAL wFileHandle%)
DECLARE FUNCTION  ctwdOutput% CDECL (BYVAL wIOHandle%, BYVAL wFileHandle%)
DECLARE FUNCTION  ctwdPause% CDECL (BYVAL wIOHandle%)
DECLARE FUNCTION  ctwdSetDiskBuffer% CDECL (BYVAL wIOHandle%, BYVAL lpBuffer&, BYVAL w2kBHalfBufferSize%)
DECLARE FUNCTION  ctwdSetDMABuffer% CDECL (BYVAL wIOHandle%, BYVAL dw32BitAddx&, BYVAL w2kBHalfBufferSize%)
DECLARE FUNCTION  ctwdSetIOParam% CDECL (BYVAL wIOHandle%, BYVAL wParamType%, BYVAL dwParam&)
DECLARE SUB       ctwdSetSpeaker CDECL (BYVAL wfOnOff%)
DECLARE FUNCTION  ctwdStop% CDECL (BYVAL wIOHandle%)
DECLARE SUB       ctwdTerminate CDECL ()


' This function is used to set the entry point of the loaded CTWDSK driver.
' It has to be called before any other CTWDSK drivers' functions.

DECLARE SUB       ctwdSetDriverEntry (BYVAL wDrvSeg%)


'---------------------------------------------------------------------------'
'  Manifest constants for the {wParamType} argument of                      '
'           ctwmGetParam()                                                  '
'       and ctwdGetParam()                                                  '
'---------------------------------------------------------------------------'
Const CTWAVxDRIVERVERSION        = &H0001
Const CTWAVxCARDTYPE             = &H0002
Const CTWAVxLPCARDNAME           = &H0003
Const CTWAVxINPUTCHANNELS        = &H0004
Const CTWAVxOUTPUTCHANNELS       = &H0005
Const CTWAVxIOHANDLES            = &H0007
Const CTWAVxDRIVERBUILD          = &H0008
Const CTWAVxSAMPLINGRANGE        = &H000A
Const CTWAVxINPUTHANDLES         = &H000B
Const CTWAVxOUTPUTHANDLES        = &H000C
Const CTWAVxNEEDDMABUFFER        = &H000D



'--------------------------------------------------------------------------'
' Manifest constants for the {wParamType} argument of                      '
'         ctwmSetIOParam(), ctwmGetIOParam()                               '
'      and ctwdSetIOParam(), ctwdGetIOParam()                              '
'--------------------------------------------------------------------------'
Const CTWAVxIOxLPSTATUSWORD      = &H0001
Const CTWAVxINxSAMPLESPERSEC     = &H0003
Const CTWAVxINxNCHANNELS         = &H0004
Const CTWAVxINxLEFTINPUTS        = &H0005
Const CTWAVxINxRIGHTINPUTS       = &H0006
Const CTWAVxINxFORMAT            = &H0007
Const CTWAVxINxBITSPERSAMPLE     = &H0008
Const CTWAVxINxFILTER            = &H0009
Const CTWAVxOUTxFILTER           = &H000A



'--------------------------------------------------------------------------'
'   Manifest constants for the {dwParam} argument of                       '
'         ctwmSetIOParam(), ctwmGetIOParam()                               '
'       and ctwdSetIOParam(), ctwdGetIOParam()                             '
'   when {wParamType == CTWAVINFORMAT}                                     '
'--------------------------------------------------------------------------'
Const WAVExFORMATxPCM              = &H0001
Const WAVExFORMATxALAW             = &H0006
Const WAVExFORMATxMULAW            = &H0007
Const WAVExFORMATxCREATIVExADPCM   = &H0200


'---------------------------------------------------------------------------'
' Manifest constants for the {dwParam} argument of                          '
'          ctwmSetIOParam(), ctwmGetIOParam()                               '
'      and ctwdSetIOParam(), ctwdGetIOParam()                               '
' when {wParamType == CTWAVxINxFILTER or CTWAVxOUTxFILTER}                  '
'---------------------------------------------------------------------------'
CONST FILTERxOFF    = 0
CONST FILTERxLOW    = &H0000FFFF&
CONST FILTERxHIGH   = &HFFFF0000&
CONST FILTERxON     = &HFFFFFFFF&

' End of file
