/*===========================================================================*\
 | SBKVOICE.H (revision 1.0)                                                 |
 |      API for CT-VOICE.DRV and CTVSDK.DRV                                  |
 |                                                                           |
 |---------------------------------------------------------------------------|
 |             Copyright (c) Creative Technology Ltd, 1991-1993.             |
 |                           All Rights Reserved.                            |
\*===========================================================================*/

#ifndef _SBKVOICE_H
    #define _SBKVOICE_H


#include "ctstddef.h"


#ifdef __cplusplus
extern "C" {
#endif



/* Many functions return 0 if nothing went wrong.
 */
#ifndef NO_ERROR
     #define NO_ERROR   0
#endif



/*---------------------------------------------------------------------------*\
 | Set this pointer to the very first byte of the loaded driver.             |
\*---------------------------------------------------------------------------*/
extern LPVOID   voice_drv;      /* For CT-VOICE.DRV */
extern LPVOID   ctvdsk_drv;     /* For   CTVDSK.DRV */



/*---------------------------------------------------------------------------*\
 | Manifest constants for the {wParamType} argument of                       |
 |          ctvmGetParam()                                                   |
 |      and ctvdGetParam()                                                   |
\*---------------------------------------------------------------------------*/
#define CTVOC_DRIVERVERSION     0x0001
#define CTVOC_CARDTYPE          0x0002
#define CTVOC_LPCARDNAME        0x0003
#define CTVOC_INPUTCHANNELS     0x0004
#define CTVOC_OUTPUTCHANNELS    0x0005
#define CTVOC_DRIVERSIZE        0x0006      /* units: bytes */
#define CTVOC_IOHANDLES         0x0007
#define CTVOC_DRIVERBUILD       0x0008
#define CTVOC_EMBDDMABUFSIZE    0x0009      /* units: 2KB per HalfBuffer */
#define CTVOC_SAMPLINGRANGE     0x000A
#define CTVOC_INPUTHANDLES      0x000B
#define CTVOC_OUTPUTHANDLES     0x000C
#define CTVOC_NEEDDMABUFFER     0x000D




/*---------------------------------------------------------------------------*\
 | Manifest constants for the {wParamType} argument of                       |
 |          ctvmSetIOParam(), ctvmGetIOParam()                               |
 |      and ctvdSetIOParam(), ctvdGetIOParam()                               |
\*---------------------------------------------------------------------------*/
#define CTVOC_IO_LPSTATUSWORD       0x0001
#define CTVOC_IN_SAMPLESPERSEC      0x0003
#define CTVOC_IN_NCHANNELS          0x0004
#define CTVOC_IN_LEFTINPUTS         0x0005
#define CTVOC_IN_RIGHTINPUTS        0x0006
#define CTVOC_IN_FORMAT             0x0007
#define CTVOC_IN_BITSPERSAMPLE      0x0008
#define CTVOC_IN_FILTER             0x0009
#define CTVOC_OUT_FILTER            0x000A


    /*-----------------------------------------------------------------------*\
     | Manifest constants for the {dwParam} argument of                      |
     |          ctvmSetIOParam(), ctvmGetIOParam()                           |
     |      and ctvdSetIOParam(), ctvdGetIOParam()                           |
     | when {wParamType == CTVOC_IN_LEFTINPUTS or CTVOC_IN_RIGHTINPUTS}      |
    \*-----------------------------------------------------------------------*/
    #ifndef MIXERSWI_MIC
        #define MIXERSWI_MIC            0x0003
        #define MIXERSWI_CD_R           0x0004
        #define MIXERSWI_CD_L           0x0008
        #define MIXERSWI_LINE_R         0x0010
        #define MIXERSWI_LINE_L         0x0020
        #define MIXERSWI_MIDI_R         0x0040
        #define MIXERSWI_MIDI_L         0x0080
    #endif



    /*-----------------------------------------------------------------------*\
     | Manifest constants for the {dwParam} argument of                      |
     |          ctvmSetIOParam(), ctvmGetIOParam()                           |
     |      and ctvdSetIOParam(), ctvdGetIOParam()                           |
     | when {wParamType == CTVOC_IN_VOCFMT}                                  |
    \*-----------------------------------------------------------------------*/
    #define VOC_FORMAT_08_PCM           0x0000
    #define VOC_FORMAT_CT4_ADPCM        0x0001      /* Not for recording */
    #define VOC_FORMAT_CT3_ADPCM        0x0002      /* Not for recording */
    #define VOC_FORMAT_CT2_ADPCM        0x0003      /* Not for recording */
    #define VOC_FORMAT_16_PCM           0x0004
    #define VOC_FORMAT_ALAW             0x0006
    #define VOC_FORMAT_MULAW            0x0007
    #define VOC_FORMAT_CREATIVE_ADPCM   0x0200



    /*-----------------------------------------------------------------------*\
     | Manifest constants for the {dwParam} argument of                      |
     |          ctvmSetIOParam(), ctvmGetIOParam()                           |
     |      and ctvdSetIOParam(), ctvdGetIOParam()                           |
     | when {wParamType == CTVOC_IN_FILTER or CTVOC_OUT_FILTER}              |
    \*-----------------------------------------------------------------------*/
    #ifndef FILTER_OFF
        #define FILTER_OFF              0

        #define FILTER_LOW              0x0000FFFF
        #define FILTER_HIGH             0xFFFF0000

        #define FILTER_ON               0xFFFFFFFF
    #endif




/*---------------------------------------------------------------------------*\
 | Function prototypes for Memory .VOC Driver (CT-VOICE.DRV) routines.       |
\*---------------------------------------------------------------------------*/
WORD    CDECL   ctvmBreakLoop(
                    WORD    wIOHandle,
                    WORD    wMode
                    );
WORD    CDECL   ctvmContinue(
                    WORD    wIOHandle
                    );
WORD    CDECL   ctvmGetDrvError(
                    void
                    );
WORD    CDECL   ctvmGetEnvSettings(
                    LPCSTR  lpszBlaster
                    );
WORD    CDECL   ctvmGetIOParam(
                    WORD    wIOHandle,
                    WORD    wParamType,
                    LPDWORD lpdwParam
                    );
WORD    CDECL   ctvmGetParam(
                    WORD    wParamType,
                    LPDWORD lpdwParam
                    );
WORD    CDECL   ctvmInit(
                    void
                    );
WORD    CDECL   ctvmInputCM(
                    WORD    wIOHandle,
                    LPBYTE  lpBuf,
                    DWORD   dwBufLen
                    );
WORD    CDECL   ctvmInputXM(
                    WORD    wIOHandle,
                    WORD    wXMBHandle,
                    DWORD   dwXMBOffset,
                    WORD    wKBBufferSize
                    );
WORD    CDECL   ctvmOutputCM(
                    WORD    wIOHandle,
                    LPBYTE  lpBuf
                    );
WORD    CDECL   ctvmOutputXM(
                    WORD    wIOHandle,
                    WORD    wXMBHandle,
                    DWORD   dwXMBOffset
                    );
WORD    CDECL   ctvmPause(
                    WORD    wIOHandle
                    );
WORD    CDECL   ctvmSetDMABuffer(
                    WORD    wIOHandle,
                    DWORD   dw32BitAddx,
                    WORD    w2KBHalfBufferSize
                    );
WORD    CDECL   ctvmSetIOParam(
                    WORD    wIOHandle,
                    WORD    wParamType,
                    DWORD   dwParam
                    );
void    CDECL   ctvmSetSpeaker(
                    WORD    wfOnOff
                    );
WORD    CDECL   ctvmStop(
                    WORD    wIOHandle
                    );
void    CDECL   ctvmTerminate(
                    void
                    );




/*---------------------------------------------------------------------------*\
 | Function prototypes for Disk .VOC Driver (CTVDSK.DRV) routines.           |
\*---------------------------------------------------------------------------*/
WORD    CDECL   ctvdBreakLoop(
                    WORD    wIOHandle,
                    WORD    wMode
                    );
WORD    CDECL   ctvdContinue(
                    WORD    wIOHandle
                    );
WORD    CDECL   ctvdGetDrvError(
                    void
                    );
WORD    CDECL   ctvdGetEnvSettings(
                    LPCSTR  lpszBlaster
                    );
WORD    CDECL   ctvdGetExtError(
                    void
                    );
WORD    CDECL   ctvdGetIOParam(
                    WORD    wIOHandle,
                    WORD    wParamType,
                    LPDWORD lpdwParam
                    );
WORD    CDECL   ctvdGetParam(
                    WORD    wParamType,
                    LPDWORD lpdwParam
                    );
WORD    CDECL   ctvdInit(
                    void
                    );
WORD    CDECL   ctvdInput(
                    WORD    wIOHandle,
                    WORD    wFileHandle
                    );
WORD    CDECL   ctvdOutput(
                    WORD    wIOHandle,
                    WORD    wFileHandle
                    );
WORD    CDECL   ctvdOutputOffset(
                    WORD    wIOHandle,
                    WORD    wFileHandle,
                    LONG    lOffsetFromCurFilePos
                    );
WORD    CDECL   ctvdPause(
                    WORD    wIOHandle
                    );
WORD    CDECL   ctvdSetDMABuffer(
                    WORD    wIOHandle,
                    DWORD   dw32BitAddx,
                    WORD    w2KBHalfBufferSize
                    );
WORD    CDECL   ctvdSetDiskBuffer(
                    WORD    wIOHandle,
                    LPBYTE  lpBuffer,
                    WORD    w2KBHalfBufferSize
                    );
WORD    CDECL   ctvdSetIOParam(
                    WORD    wIOHandle,
                    WORD    wParamType,
                    DWORD   dwParam
                    );
void    CDECL   ctvdSetSpeaker(
                    WORD    wfOnOff
                    );
WORD    CDECL   ctvdStop(
                    WORD    wIOHandle
                    );
void    CDECL   ctvdTerminate(
                    void
                    );



/*---------------------------------------------------------------------------*\
 | Creative Voice file (.VOC) header structure                               |
\*---------------------------------------------------------------------------*/
#ifndef VOCHDR_TYPEDEF
    #define VOCHDR_TYPEDEF
    typedef struct
        {
        char   id[20];
        WORD   voice_offset;
        WORD   version;
        WORD   check_code;
        } VOCHDR;
#endif

/* New Voice block type 9 */
#ifndef BLKTYPE9_TYPEDEF
    #define BLKTYPE9_TYPEDEF
    typedef struct
        {
        BYTE    bBlockID;           /* == 9 */
        BYTE    nBlockLen[3];       /* block length from dwSamplesPerSec */
        DWORD   dwSamplesPerSec;    /* number of samples per second */
        BYTE    bBitsPerSample;     /* sample length in bit */
        BYTE    bChannels;          /* number of channel - stereo or mono */
        WORD    wFormat;            /* compression format */
        BYTE    reserved[4];        /* reserved 4 bytes for future enhancement */
        } VOCBLKTYPE9;
#endif


#ifdef __cplusplus
}
#endif


#endif      /* #ifndef _SBKVOICE_H */
