'*==========================================================================*'
'*  SBKVOICE.BI (revision 1.0)                                              *'
'*       API for CT-VOICE.DRV and CTVSDK.DRV                                *'
'*                                                                          *'
'*--------------------------------------------------------------------------*'
'*              Copyright (c) Creative Technology Ltd, 1991-1993.           *'
'*                            All Rights Reserved.                          *'
'*==========================================================================*'


'
' The following are API for CT-VOICE driver.
'

DECLARE FUNCTION  ctvmBreakLoop% CDECL (BYVAL wIOHandle%, BYVAL wBreakLoop%)
DECLARE FUNCTION  ctvmContinue% CDECL (BYVAL wIOHandle%)
DECLARE FUNCTION  ctvmGetDrvError% CDECL ()
DECLARE FUNCTION  ctvmGetEnvSettings% CDECL (BYVAL lpszBlaster&)
DECLARE FUNCTION  ctvmGetIOParam% CDECL (BYVAL wIOHandle%, BYVAL wParamType%, SEG lpdwParam&)
DECLARE FUNCTION  ctvmGetParam% CDECL (BYVAL wParamType%, SEG lpdwParam&)
DECLARE FUNCTION  ctvmInit% CDECL ()
DECLARE FUNCTION  ctvmInputCM% CDECL (BYVAL wIOHandle%, BYVAL lpBuf&, BYVAL dwBufLen&)
DECLARE FUNCTION  ctvmInputXM% CDECL (BYVAL wIOHandle%, BYVAL wXMBHandle%, BYVAL dwXMBOffset&, BYVAL wkBXMBSize%)
DECLARE FUNCTION  ctvmOutputCM% CDECL (BYVAL wIOHandle%, BYVAL lpBuf&)
DECLARE FUNCTION  ctvmOutputXM% CDECL (BYVAL wIOHandle%, BYVAL wXMBHandle%, BYVAL dwXMBOffset&)
DECLARE FUNCTION  ctvmPause% CDECL (BYVAL wIOHandle%)
DECLARE FUNCTION  ctvmSetDMABuffer% CDECL (BYVAL wIOHandle%, BYVAL dw32BitAddx&, BYVAL w2kBHalfBufferSize%)
DECLARE FUNCTION  ctvmSetIOParam% CDECL (BYVAL wIOHandle%, BYVAL wParamType%, BYVAL dwParam&)
DECLARE SUB       ctvmSetSpeaker CDECL (BYVAL wfOnOff%)
DECLARE FUNCTION  ctvmStop% CDECL (BYVAL wIOHandle%)
DECLARE SUB       ctvmTerminate CDECL ()


' This function is used to set the entry point of the loaded CT-VOICE driver.
' It has to be called before any other CT-VOICE drivers' functions.

DECLARE SUB       ctvmSetDriverEntry (BYVAL wDrvSeg%)


'
' The following are API for CTVDSK driver.
'

DECLARE FUNCTION  ctvdBreakLoop% CDECL (BYVAL wIOHandle%, BYVAL wBreakLoop%)
DECLARE FUNCTION  ctvdContinue% CDECL (BYVAL wIOHandle%)
DECLARE FUNCTION  ctvdGetDrvError% CDECL ()
DECLARE FUNCTION  ctvdGetEnvSettings% CDECL (BYVAL lpszBlaster&)
DECLARE FUNCTION  ctvdGetExtError% CDECL ()
DECLARE FUNCTION  ctvdGetIOParam% CDECL (BYVAL wIOHandle%, BYVAL wParamType%, SEG lpdwParam&)
DECLARE FUNCTION  ctvdGetParam% CDECL (BYVAL wParamType%, SEG lpdwParam&)
DECLARE FUNCTION  ctvdInit% CDECL ()
DECLARE FUNCTION  ctvdInput% CDECL (BYVAL wIOHandle%, BYVAL wFileHandle%)
DECLARE FUNCTION  ctvdOutput% CDECL (BYVAL wIOHandle%, BYVAL wFileHandle%)
DECLARE FUNCTION  ctvdPause% CDECL (BYVAL wIOHandle%)
DECLARE FUNCTION  ctvdSetDiskBuffer% CDECL (BYVAL wIOHandle%, BYVAL lpBuffer&, BYVAL w2kBHalfBufferSize%)
DECLARE FUNCTION  ctvdSetDMABuffer% CDECL (BYVAL wIOHandle%, BYVAL dw32BitAddx&, BYVAL w2kBHalfBufferSize%)
DECLARE FUNCTION  ctvdSetIOParam% CDECL (BYVAL wIOHandle%, BYVAL wParamType%, BYVAL dwParam&)
DECLARE SUB       ctvdSetSpeaker CDECL (BYVAL wfOnOff%)
DECLARE FUNCTION  ctvdStop% CDECL (BYVAL wIOHandle%)
DECLARE SUB       ctvdTerminate CDECL ()
DECLARE FUNCTION  ctvdOutputOffset% CDECL (BYVAL wIOHandle%, BYVAL wFileHandle%, BYVAL lOffsetFromCurFilePos&)


' This function is used to set the entry point of the loaded CTVDSK driver.
' It has to be called before any other CTVDSK drivers' functions.

DECLARE SUB       ctvdSetDriverEntry (BYVAL wDrvSeg%)


'---------------------------------------------------------------------------'
' Creative Voice file (.VOC) header structure                               '
'---------------------------------------------------------------------------'
TYPE VOCHDR
     id         AS STRING * 20
     offset     AS INTEGER
     version    AS INTEGER
     checkcode  AS INTEGER
END TYPE

' Creative new Voice Block Type 9
TYPE VOCBLKTYPE9
    bBlockID        AS STRING*1   '* == 9 *'
    nBlockLen       AS STRING*3   '* block length from dwSamplesPerSec *'
    dwSamplesPerSec AS LONG       '* number of samples per second *'
    bBitsPerSample  AS STRING*1   '* sample length in bit *'
    bChannels       AS STRING*1   '* number of channel - stereo or mono *'
    wFormat         AS INTEGER    '* compression format *'
    reserved        AS STRING*4   '* reserved 4 bytes for future enhancement *'
END TYPE


'---------------------------------------------------------------------------'
' Manifest constants for the {wParamType} argument of                       '
'          ctvmGetParam()                                                   '
'      and ctvdGetParam()                                                   '
'---------------------------------------------------------------------------'

CONST CTVOCxDRIVERVERSION    = &H0001
CONST CTVOCxCARDTYPE         = &H0002
CONST CTVOCxLPCARDNAME       = &H0003
CONST CTVOCxINPUTCHANNELS    = &H0004
CONST CTVOCxOUTPUTCHANNELS   = &H0005
CONST CTVOCxDRIVERSIZE       = &H0006   ' units: bytes
CONST CTVOCxIOHANDLES        = &H0007
CONST CTVOCxDRIVERBUILD      = &H0008
CONST CTVOCxEMBDDMABUFSIZE   = &H0009   ' units: 2kB per HalfBuffer
CONST CTVOCxSAMPLINGRANGE    = &H000A
CONST CTVOCxINPUTHANDLES     = &H000B
CONST CTVOCxOUTPUTHANDLES    = &H000C
CONST CTVOCxNEEDDMABUFFER    = &H000D


'---------------------------------------------------------------------------'
' Manifest constants for the {wParamType} argument of                       '
'         ctvmSetIOParam(), ctvmGetIOParam()                                '
'      and ctvdSetIOParam(), ctvdGetIOParam()                               '
'---------------------------------------------------------------------------'
CONST CTVOCxIOxLPSTATUSWORD      = &H0001
CONST CTVOCxINxSAMPLESPERSEC     = &H0003
CONST CTVOCxINxNCHANNELS         = &H0004
CONST CTVOCxINxLEFTINPUTS        = &H0005
CONST CTVOCxINxRIGHTINPUTS       = &H0006
CONST CTVOCxINxFORMAT            = &H0007
CONST CTVOCxINxBITSPERSAMPLE     = &H0008
CONST CTVOCxINxFILTER            = &H0009
CONST CTVOCxOUTxFILTER           = &H000A


'---------------------------------------------------------------------------'
' Manifest constants for the {dwParam} argument of                          '
' ctvmSetIOParam(), ctvmGetIOParam()                                        '
' and ctvdSetIOParam(), ctvdGetIOParam()                                    '
' when {wParamType == CTVOCxINxVOCFMT}                                      '
'---------------------------------------------------------------------------'
CONST VOCxFORMATx08xPCM          = &H0000
CONST VOCxFORMATxCT4xADPCM       = &H0001   ' Not for recording
CONST VOCxFORMATxCT3xADPCM       = &H0002   ' Not for recording
CONST VOCxFORMATxCT2xADPCM       = &H0003   ' Not for recording
CONST VOCxFORMATx16xPCM          = &H0004
CONST VOCxFORMATxALAW            = &H0006
CONST VOCxFORMATxMULAW           = &H0007
CONST VOCxFORMATxCREATIVExADPCM  = &H0200


'---------------------------------------------------------------------------'
' Manifest constants for the {dwParam} argument of                          '
'          ctvmSetIOParam(), ctvmGetIOParam()                               '
'      and ctvdSetIOParam(), ctvdGetIOParam()                               '
' when {wParamType == CTVOCxINxFILTER or CTVOCxOUTxFILTER}                  '
'---------------------------------------------------------------------------'
CONST FILTERxOFF    = 0
CONST FILTERxLOW    = &H0000FFFF&
CONST FILTERxHIGH   = &HFFFF0000&
CONST FILTERxON     = &HFFFFFFFF&
' End of file
