/*===========================================================================*\
 | SBKAUX.H (revision 1.1)                                                   |
 |      API for AUXDRV.DRV, the DOS Auxiliary Driver                         |
 |                                                                           |
 |---------------------------------------------------------------------------|
 |             Copyright (c) Creative Technology Ltd, 1991-1995.             |
 |                           All Rights Reserved.                            |
\*===========================================================================*/

#ifndef _SBKAUX_H
    #define _SBKAUX_H


#include "ctstddef.h"


#ifdef __cplusplus
extern "C" {
#endif




/*---------------------------------------------------------------------------*\
 | Set this pointer to the very first byte of the loaded driver.             |
\*---------------------------------------------------------------------------*/
extern LPVOID   CTAuxDrv;



/*---------------------------------------------------------------------------*\
 | Mixer Switches.                                                           |
\*---------------------------------------------------------------------------*/
#ifndef MIXERSWI_MIC
    #define MIXERSWI_MIC        0x0003
    #define MIXERSWI_CD_R       0x0004
    #define MIXERSWI_CD_L       0x0008
    #define MIXERSWI_LINE_R     0x0010
    #define MIXERSWI_LINE_L     0x0020
    #define MIXERSWI_MIDI_R     0x0040
    #define MIXERSWI_MIDI_L     0x0080
#endif



/*---------------------------------------------------------------------------*\
 | Volume Sources.                                                           |
\*---------------------------------------------------------------------------*/
#define MIXERVOL_MASTER         0
#define MIXERVOL_VOICE          1
#define MIXERVOL_MIDI           2
#define MIXERVOL_CD             3
#define MIXERVOL_LINE           4
#define MIXERVOL_MIC            5
#define MIXERVOL_PCSPEAKER      6



/*---------------------------------------------------------------------------*\
 | Query Mixer Functions                                                     |
\*---------------------------------------------------------------------------*/
#define QUERY_ADDINFO       0x0000
#define QUERY_LRECSRC       0x0001
#define QUERY_RRECSRC       0x0002
#define QUERY_LMUTE         0x0003
#define QUERY_RMUTE         0x0004
#define QUERY_VOLSRC        0x0005
#define QUERY_TONECTRL      0x0006
#define QUERY_GAINCTRL      0x0007
#define QUERY_AGC           0x0008
#define QUERY_FILTER        0x0009



/*---------------------------------------------------------------------------*\
 | Miscellaneous Controls.                                                   |
\*---------------------------------------------------------------------------*/
#define FADE      0               /* For ctadClrSource() */
#define PAN       1

#define INPUT     0               /* Select INPUT or OUTPUT Mixer */
#define OUTPUT    1

#define TREBLE    0               /* Tone control */
#define BASS      1

#define OFF       0               /* For ctadSetAGC() */
#define ON        1

#define IN_FILTER_LOW       0
#define IN_FILTER_HIGH      1
#define IN_FILTER_OFF       2
#define OUT_FILTER_OFF      0
#define OUT_FILTER_ON       1



/*---------------------------------------------------------------------------*\
 | Function prototypes.                                                      |
\*---------------------------------------------------------------------------*/
WORD    CDECL   ctadFade(
                    WORD    wVolSource,
                    WORD    wFinalLevel,
                    WORD    wCycleTime,
                    WORD    wFadeMode,
                    WORD    wRepeatCount
                    );
WORD    CDECL   ctadGetAGC(
                    void
                    );
WORD    CDECL   ctadGetDrvVer(
                    void
                    );
WORD    CDECL   ctadGetEnvSettings(
                    LPCSTR  lpszBlaster
                    );
WORD    CDECL   ctadGetMixerGain(
                    WORD    wMixer
                    );
DWORD   CDECL   ctadGetMixerSwitch(
                    WORD    wMixer
                    );
WORD    CDECL   ctadGetToneLevel(
                    WORD    wTone
                    );
WORD    CDECL   ctadGetVolume(
                    WORD    wVolSource
                    );
void    CDECL   ctadInit(
                    void
                    );
WORD    CDECL   ctadPan(
                    WORD    wVolSource,
                    WORD    wInitialPos,
                    WORD    wFinalPos,
                    WORD    wCycleTime,
                    WORD    wPanMode,
                    WORD    wRepeatCount
                    );
WORD    CDECL   ctadPauseCtrl(
                    void
                    );
void    CDECL   ctadResetMixer(
                    void
                    );
WORD    CDECL   ctadSetAGC(
                    WORD    wfOnOff
                    );
void    CDECL   ctadSetFadeStAddx(
                    LPWORD  lpwFadeStatus
                    );
WORD    CDECL   ctadSetMixerGain(
                    WORD    wMixer,
                    WORD    wGain
                    );
WORD    CDECL   ctadSetMixerSwitch(
                    WORD    wMixer,
                    DWORD   dwSwitches
                    );
WORD    CDECL   ctadSetPanPosition(
                    WORD    wVolSource,
                    WORD    wPos
                    );
void    CDECL   ctadSetPanStAddx(
                    LPWORD lpwPanStatus
                    );
WORD    CDECL   ctadSetToneLevel(
                    WORD    wTone,
                    WORD    wLevel
                    );
WORD    CDECL   ctadSetVolume(
                    WORD    wVolSource,
                    WORD    wLevel
                    );
WORD    CDECL   ctadStartCtrl(
                    void
                    );
WORD    CDECL   ctadStopCtrl(
                    void
                    );
void    CDECL   ctadTerminate(
                    void
                    );
WORD    CDECL   ctadClrSource(
                    WORD    wVolSource,
                    WORD    wEffect
                    );
WORD    CDECL   ctadGetPanPosition(
                    WORD    wVolSource
                    );
WORD    CDECL   ctadSetFilter(
                    WORD    wFilter,
                    WORD    wMode
                    );
WORD    CDECL   ctadGetFilter(
                    WORD    wFilter
                    );
DWORD	CDECL	ctadQueryMixerCaps(
                    WORD    wSubFunction
                    );

#ifdef __cplusplus
}
#endif


#endif      /* #ifndef _SBKAUX_H */
