'*==========================================================================*'
'*  SBKAUX.BI (revision 1.1)                                                *'
'*       API for AUXDRV.DRV, the DOS Auxiliary Driver                       *'
'*                                                                          *'
'*--------------------------------------------------------------------------*'
'*             Copyright (c) Creative Technology Ltd, 1991-1995.            *'
'*                           All Rights Reserved.                           *'
'*==========================================================================*'

'
' The following are functions interface to AUXDRV driver.
'

DECLARE FUNCTION  ctadClrSource% CDECL (BYVAL wVolSource%, BYVAL wEffect%)
DECLARE FUNCTION  ctadFade% CDECL (BYVAL wVolSource%, BYVAL wFinalVol%, BYVAL wCycleTime%, BYVAL wFadeMode%, BYVAL wRepCount%)
DECLARE FUNCTION  ctadGetAGC% CDECL ()
DECLARE FUNCTION  ctadGetDrvVer% CDECL ()
DECLARE FUNCTION  ctadGetEnvSettings% CDECL (BYVAL lpszBlaster&)
DECLARE FUNCTION  ctadGetMixerGain% CDECL (BYVAL wMixer%)
DECLARE FUNCTION  ctadGetMixerSwitch& CDECL (BYVAL wMixer%)
DECLARE FUNCTION  ctadGetPanPosition% CDECL (BYVAL wVolSource%)
DECLARE FUNCTION  ctadGetToneLevel% CDECL (BYVAL wTone%)
DECLARE FUNCTION  ctadGetVolume% CDECL (BYVAL wVolSource%)
DECLARE SUB       ctadInit CDECL ()
DECLARE FUNCTION  ctadPan% CDECL (BYVAL wVolSource%, BYVAL wInitialPos%, BYVAL wFinalPos%, BYVAL wCycleTime%, BYVAL wPanMode%, BYVAL wRepCount%)
DECLARE FUNCTION  ctadPauseCtrl% CDECL ()
DECLARE SUB       ctadResetMixer CDECL ()
DECLARE FUNCTION  ctadSetAGC% CDECL (BYVAL wfOnOff%)
DECLARE SUB       ctadSetFadeStAddx CDECL (SEG lpwFadeStatus%)
DECLARE FUNCTION  ctadSetMixerGain% CDECL (BYVAL wMixer%, BYVAL wGain%)
DECLARE FUNCTION  ctadSetMixerSwitch% CDECL (BYVAL wMixer%, BYVAL dwSwitches&)
DECLARE FUNCTION  ctadSetPanPosition% CDECL (BYVAL wVolSource%, BYVAL wPos%)
DECLARE SUB       ctadSetPanStAddx CDECL (SEG lpwPanStatus%)
DECLARE FUNCTION  ctadSetToneLevel% CDECL (BYVAL wTone%, BYVAL wLevel%)
DECLARE FUNCTION  ctadSetVolume% CDECL (BYVAL wVolSource%, BYVAL wLevel%)
DECLARE FUNCTION  ctadStartCtrl% CDECL ()
DECLARE FUNCTION  ctadStopCtrl% CDECL ()
DECLARE SUB       ctadTerminate CDECL ()
DECLARE FUNCTION  ctadSetFilter% CDECL (BYVAL wFilter%, BYVAL wMode%)
DECLARE FUNCTION  ctadGetFilter% CDECL (BYVAL wFilter%)
DECLARE FUNCTION  ctadQueryMixerCaps& CDECL (BYVAL wSubFunction%)


' This function is used to set the entry point of the loaded driver.
' It has to be called before any other functions listed above.

DECLARE SUB       ctadSetDriverEntry (BYVAL wDrvSeg%)


' Mixer input and output switches
CONST MIXERSWIxMIC       = &H0003
CONST MIXERSWIxCDxR      = &H0004
CONST MIXERSWIxCDxL      = &H0008
CONST MIXERSWIxLINExR    = &H0010
CONST MIXERSWIxLINExL    = &H0020
CONST MIXERSWIxMIDIxR    = &H0040
CONST MIXERSWIxMIDIxL    = &H0080

' Mixer volume sources
CONST MIXERVOLxMASTER    = 0
CONST MIXERVOLxVOICE     = 1
CONST MIXERVOLxMIDI      = 2
CONST MIXERVOLxCD        = 3
CONST MIXERVOLxLINE      = 4
CONST MIXERVOLxMIC       = 5
CONST MIXERVOLxPCSPEAKER = 6

' Miscellaneous Controls.
CONST MxFADE             = 0        ' For ctadClrSource()
CONST MxPAN              = 1

CONST MxINPUT            = 0        ' Select INPUT or OUTPUT Mixer
CONST MxOUTPUT           = 1

CONST MxTREBLE           = 0        ' Tone control
CONST MxBASS             = 1

CONST MxOFF              = 0        ' For ctadSetAGC()
CONST MxON               = 1

CONST INxFILTERxLOW      = 0
CONST INxFILTERxHIGH     = 1
CONST INxFILTERxOFF      = 2
CONST OUTxFILTERxOFF     = 0
CONST OUTxFILTERxON      = 1


' Query Mixer Functions.

CONST QUERYxADDINFO      = &H0000
CONST QUERYxLRECSRC      = &H0001
CONST QUERYxRRECSRC      = &H0002
CONST QUERYxLMUTE        = &H0003
CONST QUERYxRMUTE        = &H0004
CONST QUERYxVOLSRC       = &H0005
CONST QUERYxTONECTRL     = &H0006
CONST QUERYxGAINCTRL     = &H0007
CONST QUERYxAGC          = &H0008
CONST QUERYxFILTER       = &H0009

' End of file
