/*===========================================================================*\
 # CTSTDDEF.H (revision 1.1)                                                 #
 #      Creative Technology's standard C/C++ header file.                    #
 #                                                                           #
 #---------------------------------------------------------------------------#
 #            Copyright (c) Creative Technology Ltd, 1992-1993.              #
 #                           All Rights Reserved.                            #
 #---------------------------------------------------------------------------#
 # Author: LCKwek, May 1992                                                  #
\*===========================================================================*/

#ifndef _CTSTDDEF_H
#define _CTSTDDEF_H


#if !defined(_MSC_VER) && !defined(__BORLANDC__) && !defined(__TURBOC__)
    #error Not ready to be used on other than Microsoft C/C++, Borland C/C++ or Turbo C/C++ compilers!
#endif


#ifdef  _MSC_VER
    #if !defined(__cplusplus) && (_MSC_VER >= 700)
        #pragma warning(disable: 4001)  /* C++ single-line comments */
    #endif
    #pragma warning(disable: 4103)  /* Used #pragma pack to change alignment */
    #pragma warning(disable: 4505)  /* Unreferenced local function has been removed */
#endif


/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif


/*===========================================================================*\
 |                          Q U A L I F I E R S                              |
\*===========================================================================*/
#if defined(_MSC_VER)
    #if _MSC_VER < 700
        #define CDECL       _cdecl
        #define PASCAL      _pascal
        #define LOADDS      _loadds
        #define NEAR        _near
        #define FAR         _far
        #define HUGE        _huge
        #define INTERRUPT   _interrupt
    #else
        #define CDECL       __cdecl
        #define PASCAL      __pascal
        #define LOADDS      __loadds
        #define NEAR        __near
        #define FAR         __far
        #define HUGE        __huge
        #define INTERRUPT   __interrupt
    #endif
#elif defined(__BORLANDC__) || defined(__TURBOC__)
        #define CDECL       cdecl
        #define PASCAL      pascal
        #define LOADDS      _loadds
        #define NEAR        near
        #define FAR         far
        #define HUGE        huge
        #define INTERRUPT   interrupt
#endif





/*===========================================================================*\
 |                    T Y P E    D E C L A R A T I O N S                     |
\*===========================================================================*/

#define VOID    void
typedef         VOID           *PVOID;
typedef const   VOID           *PCVOID;
typedef         VOID    NEAR   *NPVOID;
typedef const   VOID    NEAR   *NPCVOID;
typedef         VOID    FAR    *LPVOID;
typedef const   VOID    FAR    *LPCVOID;


typedef signed      char        SCHAR;
typedef unsigned    char        UCHAR;

typedef             char        CHAR;
typedef         CHAR           *PSTR;
typedef const   CHAR           *PCSTR;
typedef         CHAR    NEAR   *NPSTR;
typedef const   CHAR    NEAR   *NPCSTR;
typedef         CHAR    FAR    *LPSTR;
typedef const   CHAR    FAR    *LPCSTR;

typedef unsigned    char        BYTE;       /* 8 bits  */
typedef         BYTE           *PBYTE;
typedef const   BYTE           *PCBYTE;
typedef         BYTE    NEAR   *NPBYTE;
typedef const   BYTE    NEAR   *NPCBYTE;
typedef         BYTE    FAR    *LPBYTE;
typedef const   BYTE    FAR    *LPCBYTE;
typedef         BYTE    HUGE   *HPBYTE;
typedef const   BYTE    HUGE   *HPCBYTE;


typedef signed      short       SHORT;
typedef unsigned    short       USHORT;

typedef unsigned    short       WORD;       /* 16 bits */
typedef         WORD           *PWORD;
typedef         WORD    NEAR   *NPWORD;
typedef         WORD    FAR    *LPWORD;


typedef             int         INT;
typedef unsigned    int         UINT;


typedef signed      long        LONG;
typedef LONG                   *PLONG;

typedef unsigned    long        ULONG;
typedef ULONG                  *PULONG;

typedef unsigned    long        DWORD;      /* 32 bits */
typedef         DWORD          *PDWORD;
typedef         DWORD   NEAR   *NPDWORD;
typedef         DWORD   FAR    *LPDWORD;




typedef         WORD            BOOL;
typedef         BOOL           *PBOOL;
typedef         BOOL    NEAR   *NPBOOL;
typedef         BOOL    FAR    *LPBOOL;
    #ifndef FALSE
        #define FALSE   0
    #endif
    #ifndef TRUE
        #define TRUE    1
    #endif


typedef WORD    FUNCSTATUS;
    #define FUNCSTATUS_SUCCESS  0
    #define FUNCSTATUS_ERROR    1



/*===========================================================================*\
 |===========================================================================|
 |                              M A C R O S                                  |
\*===========================================================================*/

/* To make explicitly clear that the null statement is intended, as in
 *
 *          while (*dest++ = *source++)
 *              NOTHING;
 */
#define NOTHING


/* For specifying the nature of the parameters to a function.
 * Use like so:
 *     VOID ReadPort(IN WORD wPort, OUT LPBYTE lpb);
 *     VOID GetSamplingLimit(IN OUT lpdwParam);
 *     INT  open(IN PCSTR szname, IN INT oflag, IN INT pmode OPTIONAL);
 */
#define IN
#define OUT
#define OPTIONAL




/*===========================================================================*\
 |===========================================================================|
 |                     M A C R O     F U N C T I O N S                       |
\*===========================================================================*/

#ifndef MK_FP
    #define MK_FP(seg,ofs)  (LPVOID)((((DWORD)((WORD)(seg)))<<16) + (WORD)(ofs))
#endif

#ifndef FPSEG
    #define FPSEG(fp)      (*((unsigned FAR *)&(fp) + 1))
    #define FPOFF(fp)      (*((unsigned FAR *)&(fp)))
#endif

#ifndef HIBYTE
    #define HIBYTE(w)       ((BYTE)(((WORD)(w)) >> 8))
    #define LOBYTE(w)       ((BYTE)(w))
#endif

#ifndef HIWORD
    #define HIWORD(dw)      ((WORD)(((DWORD)(dw)) >> 16))
    #define LOWORD(dw)      ((WORD)(dw))
#endif

#ifndef HINIBBLE
    #define HINIBBLE(b)     ((BYTE)((((BYTE)b) >> 4) & 0x0F))
    #define LONIBBLE(b)     ((BYTE)(((BYTE)b) & 0x0F))
#endif

#define MK_WORD(msb,lsb)    ((((WORD)((BYTE)(msb)))<<8) | ((WORD)((BYTE)(lsb))))

#define MK_DWORD(msw,lsw)   ((((DWORD)((WORD)(msw)))<<16) | ((WORD)(lsw)))



#define IN_RANGE(x, xmin,xmax)    ((x) >= (xmin) && (x) <= (xmax))



/* Macros used to eliminate compiler warning generated when formal
 * parameters or local variables are not declared.
 *
 *      Use UNREFERENCED_PARAMETER() if a parameter will never be referenced.
 *
 *      Use DBG_UNREFERENCED_PARAMETER() when a parameter is not yet
 *      referenced but will be once the module is completely developed.
 *
 *      Use DBG_UNREFERENCED_LOCAL_VARIABLE() when a local variable is not
 *      yet referenced but will be once the module is completely developed.
 *
 *
 *      To help determine whether there is unfinished work, define
 *      DBG_CHECK_FOR_UNFINISHED_WORK before including this file, in
 *      which case both DBG_UNREFERENCED_PARAMETER() and
 *      DBG_UNREFERENCED_LOCAL_VARIABLE() will become null macros.
 */
#ifdef DBG_CHECK_FOR_UNFINISHED_WORK
    #define UNREFERENCED_PARAMETER(P)           { (P) = (P); }
    #define DBG_UNREFERENCED_PARAMETER(P)
    #define DBG_UNREFERENCED_LOCAL_VARIABLE(V)
#else
    #define UNREFERENCED_PARAMETER(P)           { (P) = (P); }
    #define DBG_UNREFERENCED_PARAMETER(P)       { (P) = (P); }
    #define DBG_UNREFERENCED_LOCAL_VARIABLE(V)  { (V) = (V); }
#endif


/*---------------------------------------------------------------------------*/


#ifdef __cplusplus
}
#endif


#endif  /* #ifndef _CTSTDDEF_H */
