;; ------------------------------------------------------------------------ ;;
;;  @@ Source Documentation           *** MASM 6.0 Version ***              ;;
;;                                                                          ;;
;;  Title   :   MEMORY.ASM                                                  ;;
;;                                                                          ;;
;;  DOS memory allocating functions for QuickBasic 4.5, Basic PDS 7.1,	    ;;
;;  and Visual Basic for DOS version 1.0., Turbo Pascal Version 6.0         ;;
;;  and 7.0.                                                                ;;
;;                                                                          ;;
;;  Functions are:                                                          ;;
;;          sbkAllocMem                                                     ;;
;;          sbkFreeMem                                                      ;;
;;                                                                          ;;
;;                                                                          ;;
;;  Copyright (c) Creative Technology Ltd, 1993.  All rights reserved.	    ;;
;;                                                                          ;;
;;  Important Note:                                                         ;;
;;      This source code is only intended as a supplement to the            ;;
;;      existing Basic functions to facilitate the use of SBK               ;;
;;      library.                                                            ;;
;;                                                                          ;;
;;      You can use and modify these functions in any way you find          ;;
;;      useful, provided that you agree that Creative Technology Ltd        ;;
;;      has no warranty obligations or liability for any functions          ;;
;;      which are modified.                                                 ;;
;;                                                                          ;;
;; ------------------------------------------------------------------------ ;;

INCLUDE     sbkmodel.inc


	    .CODE   CodeSegmentName

;; ------------------------------------------------------------------------ ;;
;;  Allocates memory via DOS interrupt 21H function 48H.                    ;;
;;                                                                          ;;
;;  FUNCTION  sbkAllocMem% (wParaSize%)                                     ;;
;;                                                                          ;;
;;  Entry:                                                                  ;;
;;      wParaSize% :- memory size requested in paragraph                    ;;
;;                    (a paragraph is 16 bytes)                             ;;
;;                                                                          ;;
;;  Exit:                                                                   ;;
;;      Segment of the new block of memory allocated if successful,         ;;
;;      else returns 0.                                                     ;;
;; ------------------------------------------------------------------------ ;;

%   sbkAllocMem     PROC    <loaddsIF>	    wParaSize : word

    push    bx

    mov     ax, 4800H
    mov     bx, wParaSize
    int     21H

    ; carry flag set if error
    jnc     OKAY
    mov     ax, 0

OKAY:
    pop     bx
    ret

sbkAllocMem	ENDP


;; ------------------------------------------------------------------------ ;;
;;  Releases the memory previously allocated via AllocMem().                ;;
;;                                                                          ;;
;;  SUB sbkFreeMem (wSegment%)                                              ;;
;;                                                                          ;;
;;  Entry:                                                                  ;;
;;      wSegment% :- segment of the memory block to be released.            ;;
;;                                                                          ;;
;;  Exit:                                                                   ;;
;;      none.                                                               ;;
;; ------------------------------------------------------------------------ ;;

%   sbkFreeMem	    PROC    <loaddsIF>	    USES es,
                                            wSegment : word
    
    mov     ax, 4900H
    mov     es, wSegment
    int     21H

    ret

sbkFreeMem	ENDP


	    END     ;;End of code
