;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  DOSRW.ASM :- DOS read/write helper functions.
;
;    Author  : CWLim
;
;    Helper functions for Turbo C as the read() and write()
;    functions on Turbo C only take near pointer on small and medium
;    memory models.  They could not be used to read/write a file larger
;    than 64K to far memory in the memory models mentioned.
;
;    You need to use MASM 6 to assemble the program.
;
;    Copyright (c) Creative Technology Ltd, 1993, All rights reserved
;
;
;    Important Note:
;        This source code is only intended as a supplement to the
;        existing SBK functions to facilitate the use of SBK
;        library.
;
;        You can use and modify these functions in any way you find
;        useful, provided that you agree that Creative Technology Ltd
;        has no warranty obligations or liability for any functions
;        which are modified.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


        .MODEL  large, C

        .DATA

        .CODE   CT_TEXT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;    WORD sbkDosRead (int  Handle, void far * lpBuf,
;                     WORD wLen, WORD far * lpwByteRead)
;
;    DESCRIPTION:
;        Read driver to buffer using DOS interrupt 0x21 function 0x3F.
;
;    ENTRY:
;        Handle :- File handle to read.
;        lpBuf  :- Buffer to write to.
;        wLen   :- Number of byte to read.
;        lpwByteRead :- pointer to number of byte actually read.
;
;    EXIT:
;        If successful, returns 0, else returns DOS error code.
;        If successful, wByteRead show the number of bytes actually read.
;
;
;   NOTE:
;        In case crossed segment occurs, you need to perform segment and
;        offset adjustment prior to calling this function.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sbkDosRead    PROC                    Handle: WORD,
                                      lpBuf : FAR PTR BYTE,
                                      wLen  : WORD,
                                lpwByteRead : FAR PTR WORD
        PUSH  DS
        MOV   AH,3FH
        MOV   BX,Handle
        MOV   CX,wLen
        LDS   DX,lpBuf
        INT   21H
        LDS   BX,lpwByteRead
        JC    rd1
        MOV   WORD PTR [BX],AX
        XOR   AX,AX
        JMP   SHORT rd2
rd1:
        MOV   WORD PTR [BX],0
rd2:
        POP   DS
        RET
sbkDosRead    ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;    WORD sbkDosWrite (int Handle, void far *lpBuf,
;                      WORD wLen, WORD far * lpwByteWritten)
;
;    Description:
;        Write data from file using DOS interrupt 0x21 function 0x40.
;
;    Entry:
;        Handle :- File handle to read.
;        lpBuf  :- Buffer to write to.
;        wLen   :- Number of byte to read.
;        lpwByteWritten :- pointer to number of byte actually written.
;
;    Exit:
;        If successful, returns 0, else returns DOS error code.
;        If successful, wByteWritten show the number of bytes actually written.
;
;   NOTE:
;        In case crossed segment occurs, you need to perform segment and
;        offset adjustment prior to calling this function.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sbkDosWrite   PROC                    Handle: WORD,
                                      lpBuf : FAR PTR BYTE,
                                      wLen  : WORD,
                              lpwByteWritten: FAR PTR WORD
        PUSH  DS
        MOV   AH,40H
        MOV   BX,Handle
        MOV   CX,wLen
        LDS   DX,lpBuf
        INT   21H
        LDS   BX,lpwByteWritten
        JC    wr1
        MOV   WORD PTR [BX],AX
        XOR   AX,AX
        JMP   SHORT wr2
wr1:
        MOV   WORD PTR [BX],0
wr2:
        POP   DS
        RET
sbkDosWrite   ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Open an existing file via DOS interrupt 21H function 3DH.
;
;   int sbkDosOpen (char far * lpFilename)
;
;   Entry:
;       lpFilename :- far pointer to the name of the file to be opened.
;
;   Exit:
;       File handle if successful, else returns -1.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sbkDosOpen      PROC                lpFilename : far ptr byte

    push    ds
    mov     ax, 3D00H
    lds     dx, lpFilename
    int     21H

    ; carry flag set if error
    JNC     pass1
    mov     ax, -1

pass1:
    pop     ds
    ret

sbkDosOpen  ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Creates a new file via DOS interrupt 21H function 3CH.
;
;   int sbkDosCreate (char far * lpFilename)
;
;   Entry:
;       lpFilename :- far pointer to the name of the file to be created.   ;
;
;   Exit:
;       File handle if successful, else returns -1.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sbkDosCreate        PROC        lpFilename : far ptr byte

    push    ds
    mov     ax, 3C00H
    mov     cx, 20H
    lds     dx, lpFilename
    int     21H

    ; carry flag set if error
    JNC     pass2
    mov     ax, -1

pass2:
    pop     ds
    ret

sbkDosCreate    ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Closes a file.
;
;   void sbkDosClose (int FileHandle)
;
;   Entry:
;       FileHandle :- handle of file to be closed.
;
;   Exit:
;       none.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sbkDosClose     PROC                FileHandle : word

    push    ds
    push    bx
    mov     ax, 3E00H
    mov     bx,  FileHandle
    int     21H
    pop     bx
    pop     ds
    ret

sbkDosClose     ENDP

        END
