;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; CVTTYPE.ASM :- Converts a data type to another data type.
;
;   Helper function for QuickBasic 4.5, Basic PDS 7.1 and
;   Visual Basic for DOS version 1.0.
;
;   You need to use MASM 6 to assemble the program.
;
;   Author  : CWLim
;
;   Functions are:
;
;       sbkMakeDWord&()
;       sbkHighWord%()
;       sbkLowWord%()
;       sbkHighByte%()
;       sbkLowByte%()
;
;
;   Copyright (c) Creative Technology Ltd, 1993, All rights reserved
;
;   Important Note:
;       This source code is only intended as a supplement to the
;       existing Basic functions to facilitate the use of SBK
;       library.
;
;       You can use and modify these functions in any way you find
;       useful, provided that you agree that Creative Technology Ltd
;       has no warranty obligations or liability for any functions
;       which are modified.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

      .MODEL large, BASIC

      .DATA

      .CODE   CT_TEXT


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Makes a unsigned long integer.
;
;   FUNCTION sbkMakeDWord& (BYVAL wHiWord%, BYVAL wLoWord%)
;
;   Entry :
;       wHiWord% :- high order word
;       wLoWord% :- low order word
;
;   Exit  :
;       Unsigned long integer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sbkMakeDWord   PROC                   wHiWord : WORD,
                                      wLoWord : WORD
        MOV    AX,wLoWord
        MOV    DX,wHiWord
        RET
sbkMakeDWord   ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Makes a unsigned integer.
;
;   FUNCTION sbkMakeWord% (BYVAL bHiByte%, BYVAL bLoByte%)
;
;   Entry :
;       bHiByte% :- high order byte
;       bLoByte% :- low order byte
;
;   Exit  :
;       Unsigned long integer
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sbkMakeWord   PROC                   bHiByte : BYTE,
                                     bLoByte : BYTE
        MOV    AL,bLoByte
        MOV    AH,bHiByte
        RET
sbkMakeWord   ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Returns high word of a double word.
;
;   FUNCTION sbkHighWord% (BYVAL dwData&)
;
;   Entry :
;       dwData& :- double word data
;
;   Exit  :
;       High word of the double data.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sbkHighWord   PROC                    wHiWord : WORD,
                                      wLoWord : WORD
        MOV    AX,wHiWord
        RET
sbkHighWord   ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Returns low word of a double word.
;
;   FUNCTION sbkLowWord% (BYVAL dwData&)
;
;   Entry :
;       dwData& :- double word data
;
;   Exit  :
;       Low word of the double word data.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sbkLowWord    PROC                    wHiWord : WORD,
                                      wLoWord : WORD
        MOV    AX,wLoWord
        RET
sbkLowWord    ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Returns high byte of a word.
;
;   FUNCTION sbkHighByte% (BYVAL wData%)
;
;   Entry :
;       wData% :- word data
;
;   Exit  :
;       High byte of the data.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sbkHighByte   PROC                    wData : WORD
        MOV    AX,wData
        XOR    AL,AL
        XCHG   AL,AH
        RET
sbkHighByte   ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Returns low byte of a word.
;
;   FUNCTION sbkLowByte% (BYVAL wData%)
;
;   Entry :
;       wData% :- word data
;
;   Exit  :
;       Low byte of the data.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sbkLowByte   PROC                    wData : WORD
        MOV    AX,wData
        XOR    AH,AH
        RET
sbkLowByte   ENDP

	    END
