######################################################################
#
#   Makefile helper functions for Basic quick library and runtime library.
#
#   Usage:
#       NMAKE /f mkbhlp.mk  basver=<45 | 71 | vb>  goal
#
#               where   basver  45 for QuickBasic 4.5
#                               71 for Basic PDS 7.1
#                               vb for Visual Basic for DOS
#
#   Requirements:
#       1.  NMAKE is required to make this makefile.
#       2.  ML ver 6.0 or above is needed to assemble the ASM files.
#
#   Created On: 08/03/93  by CW Lim
#
######################################################################


###### Conditional for different version of BASIC ######

!if "$(basver)" == ""
basver = 45
!endif

!if "$(basver)" == "45"
PFIX	    = q
_BLIB_      = basic
_BSRC_      = $(_BLIB_)
LIBNAME     = $(_BLIB_)\qbsbkx
QLIBNAME    = $(_BLIB_)\qb45sbk
_SETLIB_    = d:\qb45;c:\sbk\lib;
_LINK_CMD_  = d:\qb45\link /Q /NOE /NOD:bcom45.lib $(LIBNAME).lib+sbkqb45.lib,$(QLIBNAME),$(QLIBNAME),bqlb45 sbkqb45;
BC          = d:\qb45\bc /O  
AFLAGS      = /DNEAR_STRING
!endif

!if "$(basver)" == "71"
PFIX        = m		
_BLIB_      = basic
_BSRC_      = $(_BLIB_)
LIBNAME     = $(_BLIB_)\b7sbkx
QLIBNAME    = $(_BLIB_)\bc7sbk
_SETLIB_    = d:\bc7\lib;c:\sbk\lib;
_LINK_CMD_  = d:\bc7\binb\link /Q /NOE /NOD:brt71efr.lib /NOD:bcl71efr.lib $(LIBNAME).lib+sbkbc7.lib,$(QLIBNAME),$(QLIBNAME),qbxqlb sbkbc7;
BC          = d:\bc7\binb\bc /O /Lr /Fs
AFLAGS      = /DFAR_STRING
!endif

!if "$(basver)" == "vb"
PFIX        = m		
_BLIB_      = basic
_BSRC_      = $(_BLIB_)
LIBNAME     = $(_BLIB_)\vbsbkx
QLIBNAME    = $(_BLIB_)\vbsbk
_SETLIB_    = c:\vbasic\lib;c:\sbk\lib;
_LINK_CMD_  = c:\vbasic\bin\link /Q /NOE /NOD:vbdrt10e.lib /NOD:vbdcl10e.lib $(LIBNAME).lib+sbkvb.lib,$(QLIBNAME),$(QLIBNAME),vbdosqlb sbkvb;
BC          = c:\vbasic\bin\bc /O
AFLAGS      = /DFAR_STRING
!endif


##### Files involve #####

##### Assembly source files ####
AOBJS1  = addxadj.obj  bstring.obj  cvttype.obj  xmsrtn.obj
AOBJS2  = fileio.obj   memory.obj

##### Basic source files
BOBJS1  = $(_BSRC_)\$(PFIX)sbkx.obj

OBJS	= $(AOBJS1) $(AOBJS2) $(BOBJS1)


##### Build options #####
AS    = d:\masm\bin\ml /Zp1 /nologo /c /I. /DMemModel=mbasic /Fo$(@B)

##### Dependents goal #####
goal:  $(LIBNAME).qlb

$(LIBNAME).lib: $(OBJS)
    !lib  /nologo $(LIBNAME) -+$(?B);

$(LIBNAME).qlb:   $(LIBNAME).lib
    SET   LINK=
    SET   LIB=$(_SETLIB_)
    $(_LINK_CMD_)
    SET   LIB=d:\c700\lib
    -del  $(_BLIB_)\*.map
    -del  $(_BLIB_)\*.bak
    -del  $(_BLIB_)\*.obj

##### Dependents #####
$(AOBJS1): $(@B).asm
$(AOBJS2): $(@B).asm
$(BOBJS1): $(@R).bas
