## ------------------------------------------------------------------------ ##
##  @@ Source Documentation     ***  Turbo C and Borland C version ***      ##
##                                                                          ##
##  Title : DEMOVXP.MAK                                                     ##
##                                                                          ##
##  Description :                                                           ##
##      Make file for DEMOVXP.C                                             ##
##                                                                          ##
##  Compile :                                                               ##
##      Borland C++ :- MAKE -DBCC -f DEMOVXP.MAK                            ##
##      Turbo C/C++ :- MAKE -fDEMOVXP.MAK                                   ##
##                                                                          ##
##      Include switch -DMODEl=c (compact model) to change memory model,    ##
##      and switch -DDEBUG to compile with debug info before -f.            ##
##                                                                          ##
##  Copyright (c) Creative Technology Ltd, 1993. All rights reserved.       ##
##                                                                          ##
## ------------------------------------------------------------------------ ##

# default memory model is small
!if !$d(MODEL)
MODEL=s
!endif

!if '$(MODEL)' == 'h'
LIBMODEL = l
!else
LIBMODEL = $(MODEL)
!endif

!if $d(BCC)
COMPILER = bcc
!else
COMPILER = tcc
!endif

!if !$d(DEBUG)
CFLAG = -m$(MODEL) -a-
!else
CFLAG = -m$(MODEL) -v -y -M -a-
!endif

CC = $(COMPILER) $(CFLAG)

TARGET = demovxp

#               *Implicit Rules*
.c.obj:
  $(COMPILER) -c $(CFLAG) $<
.cpp.obj:
  $(COMPILER) -c $(CFLAG) $<

#               *Explicit Rules*
$(TARGET).exe: $(TARGET).obj
  $(CC) $(TARGET).obj sbklib$(LIBMODEL).lib csbkx.lib

#               *Individual File Dependencies*
$(TARGET).obj: demovxp.c
