'' ------------------------------------------------------------------------ ''
''  @@ Source Documentation                     *** BASIC Version ***       ''
''                                                                          ''
''  TITLE : MIDIOUT.BAS                                                     ''
''                                                                          ''
''  DESCRIPTION :                                                           ''
''      This program demostrates how to use the CTMIDI.DRV driver           ''
''      to output MIDI codes to internal or external MIDI synthesizer.      ''
''                                                                          ''
''      Note that the BLASTER environment has to be set before executing    ''
''      this program.                                                       ''
''                                                                          ''
''  NOTE :                                                                  ''
''      Use switch /Fs for Microsoft Basic PDS version 7.1 compiler.        ''
''                                                                          ''
''  Copyright (c) Creative Technology Ltd, 1993. All rights reserved.       ''
''                                                                          ''
'' ------------------------------------------------------------------------ ''

'$INCLUDE: 'SBKMIDI.BI'
'$INCLUDE: 'SBKX.BI'


DECLARE FUNCTION PrepareCTMIDIDrv%(BlasterAddx AS LONG)

CONST   DRIVERxSIZE   = 51200&


REM $DYNAMIC
CLEAR

'* Set memory for CTMIDI driver
Dummy = SETMEM(-DRIVERxSIZE)

DIM MyStr AS STRING
DIM dwAddx AS LONG
DIM Note (0 TO 15) AS INTEGER

    '* C major notes *'
    Note(0)  = 60
    Note(1)  = 62
    Note(2)  = 64
    Note(3)  = 65
    Note(4)  = 67
    Note(5)  = 69
    Note(6)  = 71
    Note(7)  = 72
    Note(8)  = 71
    Note(9)  = 69
    Note(10) = 67
    Note(11) = 65
    Note(12) = 64
    Note(13) = 62
    Note(14) = 60
    Note(15) = 0

    PRINT "Output MIDI codes to internal or external MIDI synthesizer."

    MyStr = ENVIRON$("BLASTER")
    IF MyStr = "" THEN
        PRINT "BLASTER environment not set."
        SYSTEM
    END IF

    '* convert to null terminated string *'
    dwAddx = sbkMakeAsciizString&(MyStr)

    '* Load CTMIDI.DRV into memory *'
    IF PrepareCTMIDIDrv%(dwAddx) <> 0 THEN
        '* Initialize CTMIDI.DRV driver *'
        IF ctmdInit% = 0 THEN
            '* set synthesizer accoding to environment setting *'
            MyStr = ENVIRON$("MIDI")
            IF MyStr <> "" THEN
                '* convert to null terminated string *'
                dwAddx = sbkMakeAsciizString&(MyStr)
                retVal% = ctmdGetMidiEnvSettings%(dwAddx)
            END IF

            PRINT "Wait...Output MIDI codes...Press a key to stop."

            count% = 1

            DO
                '* send status note on, note and velocity *'
                retVal% = ctmdSendShortMessage%(&H90,Note(count%),&H70)

                FOR x% = 1 To 100
                    FOR y% =1 to 8000
                    NEXT y%
                NEXT x%

                '* send status note off, note and velocity *'
                retVal% = ctmdSendShortMessage%(&H80,Note(count%),&H70)

                count% = count% + 1

            LOOP UNTIL (Note(count%) = 0) OR (INKEY$ <> "")

            '* Terminate CTMIDI.DRV driver *'
            retVal% = ctmdTerminate%
        ELSE
            PRINT "Error CTMIDI driver initialization."
        END IF
    END IF

'* return memory *'
Dummy = SETMEM(DRIVERxSIZE)

END


'---------------------------------------------------------------------------'
'   @@ Usage                                                                '
'                                                                           '
'   FUNCTION PrepareCTMIDIDrv% (BlasterAddx AS LONG)                        '
'                                                                           '
'   Description :                                                           '
'       Load and endorse CTMIDI.DRV driver.                                 '
'                                                                           '
'   Entry :                                                                 '
'       BlasterAddx - Far address of the BLASTER setting.                   '
'                                                                           '
'   Exit :                                                                  '
'       segment of the loaded driver if successful else return 0.           '
'                                                                           '
'---------------------------------------------------------------------------'

FUNCTION PrepareCTMIDIDrv%(BlasterAddx AS LONG)

    DIM ctmidi AS INTEGER


    ctmidi = sbkLoadDriver%("CTMIDI.DRV",UNUSED)
    IF ctmidi <> 0 THEN

        CALL ctmdSetDriverEntry(ctmidi)

        IF ctmdGetDrvVer% >= &H0100 THEN

            IF ctmdGetEnvSettings%(BlasterAddx) = 0 THEN
                PrepareCTMIDIDrv% = ctmidi
                EXIT FUNCTION
            ELSE
                PRINT "BLASTER environment is not valid"
            END IF
        ELSE
            PRINT "Invalid CTMIDI.DRV - ";
            PRINT "I need CTMIDI.DRV version 1.00 or higher."
        END IF

        CALL sbkFreeMem(ctmidi)
    ELSE
        PRINT "Error loading CTMIDI.DRV or CTMIDI not found."
    END IF

    PrepareCTMIDIDrv% = 0

END FUNCTION
'* End of file *'
